/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.util;

import java.util.regex.Pattern;

public class PatternMatch {
    private static final String TRACE_MASKT = "XFRMPTMT";
    private static final String TRACE_MASKF = "XFRMPTMF";
    private static final String TRACE_MASKD = "XFRMPTMD";

    public static boolean match(String pattern, String text) {
        return Pattern.matches(pattern, text);
    }

    public static String globToRE(String glob) {
        StringBuffer buf = new StringBuffer();
        boolean backslash = false;
        boolean insideGroup = false;
        boolean insideNegativeLookahead = false;
        int i = 0;
        while (i < glob.length()) {
            char c = glob.charAt(i);
            if (backslash) {
                buf.append('\\');
                buf.append(c);
                backslash = false;
            } else {
                switch (c) {
                    case '\\': {
                        backslash = true;
                        break;
                    }
                    case '?': {
                        buf.append('.');
                        break;
                    }
                    case '.': {
                        buf.append("\\.");
                        break;
                    }
                    case '*': {
                        buf.append(".*");
                        break;
                    }
                    case '{': {
                        buf.append('(');
                        if (i + 1 != glob.length() && glob.charAt(i + 1) == '!') {
                            buf.append('?');
                            insideNegativeLookahead = true;
                            break;
                        }
                        insideGroup = true;
                        break;
                    }
                    case ',': {
                        if (insideGroup) {
                            if (insideNegativeLookahead) {
                                buf.append(").*");
                                insideNegativeLookahead = false;
                            }
                            buf.append('|');
                            break;
                        }
                        buf.append(',');
                        break;
                    }
                    case '}': {
                        if (insideNegativeLookahead) {
                            buf.append(").*");
                            insideNegativeLookahead = false;
                            break;
                        }
                        if (insideGroup) {
                            buf.append(')');
                            insideGroup = false;
                            break;
                        }
                        buf.append('}');
                        break;
                    }
                    default: {
                        buf.append(c);
                    }
                }
            }
            ++i;
        }
        return buf.toString();
    }
}

